package com.agilex.healthcare.directscheduling.domain;

import com.agilex.healthcare.mobilehealthplatform.domain.DomainTransferObjectCollection;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown = true, value = { "size" })
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
@XmlRootElement(name = "AppointmentTimeSlots", namespace = Namespace.DirectScheduling)
public class AppointmentTimeSlots extends DomainTransferObjectCollection<AppointmentTimeSlot> {

    private static final long serialVersionUID = -6576427322744622230L;

    private String clinicId;
    private String clinicName;
    private String appointmentLength;
    private String clinicDisplayStartTime;
    private String displayIncrements;
    private String stopCode;
    private String creditCode;
    private String specialty;
    private boolean askForCheckIn;
    private String maxOverbooksPerDay;
    private boolean hasUserAccessToClinic;
    private String primaryStopCode;
    private String secondaryStopCode;

    public int getListSize(){
        return super.size();
    }

    public String getClinicId() {
        return clinicId;
    }

    public void setClinicId(String clinicId) {
        this.clinicId = clinicId;
    }

    public String getClinicName() {
        return clinicName;
    }

    public void setClinicName(String clinicName) {
        this.clinicName = clinicName;
    }

    public String getAppointmentLength() {
        return appointmentLength;
    }

    public void setAppointmentLength(String appointmentLength) {
        this.appointmentLength = appointmentLength;
    }

    public String getClinicDisplayStartTime() {
        return clinicDisplayStartTime;
    }

    public void setClinicDisplayStartTime(String clinicDisplayStartTime) {
        this.clinicDisplayStartTime = clinicDisplayStartTime;
    }

    public String getDisplayIncrements() {
        return displayIncrements;
    }

    public void setDisplayIncrements(String displayIncrements) {
        this.displayIncrements = displayIncrements;
    }

    @XmlElement(namespace = Namespace.DirectScheduling)
    @JsonProperty("appointmentTimeSlot")
    public Collection<AppointmentTimeSlot> getAppointmentTimeSlot(){
        List<AppointmentTimeSlot> list = new ArrayList<AppointmentTimeSlot>();
        for (AppointmentTimeSlot appointmentTimeSlot : this) {
            list.add(appointmentTimeSlot);
        }
        return list;
    }

    public void setAppointmentTimeSlot(Collection<AppointmentTimeSlot> list){
        this.addAll(list);
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getStopCode() {
        return stopCode;
    }

    public void setStopCode(String stopCode) {
        this.stopCode = stopCode;
    }

    public String getCreditCode() {
        return creditCode;
    }

    public void setCreditCode(String creditCode) {
        this.creditCode = creditCode;
    }

    public String getSpecialty() {
        return specialty;
    }

    public void setSpecialty(String specialty) {
        this.specialty = specialty;
    }

    public boolean isAskForCheckIn() {
        return askForCheckIn;
    }

    public void setAskForCheckIn(boolean askForCheckIn) {
        this.askForCheckIn = askForCheckIn;
    }

    public String getMaxOverbooksPerDay() {
        return maxOverbooksPerDay;
    }

    public void setMaxOverbooksPerDay(String maxOverbooksPerDay) {
        this.maxOverbooksPerDay = maxOverbooksPerDay;
    }

    public boolean isHasUserAccessToClinic() {
        return hasUserAccessToClinic;
    }

    public void setHasUserAccessToClinic(boolean hasUserAccessToClinic) {
        this.hasUserAccessToClinic = hasUserAccessToClinic;
    }

    public String getPrimaryStopCode() {
        return primaryStopCode;
    }

    public void setPrimaryStopCode(String primaryStopCode) {
        this.primaryStopCode = primaryStopCode;
    }

    public String getSecondaryStopCode() {
        return secondaryStopCode;
    }

    public void setSecondaryStopCode(String secondaryStopCode) {
        this.secondaryStopCode = secondaryStopCode;
    }
}
